import { StyleSheet } from "react-native";
import dpr from "../../../../../../Utilities/CustomStyleAttribute/dpr";

const VariationOptionStyle = () =>
    StyleSheet.create({
        headerCont: {
            flexDirection: "row",
            justifyContent: "space-between",
            alignItems: "center",
            borderTopWidth: 1,
            borderColor: "#DFDFDF",
            paddingTop: dpr(15),
            marginTop: dpr(15),
        },
        title: {
            fontFamily: "DMSans_500Medium",
            fontSize: dpr(18),
            color: "#2C2C2C",
            lineHeight: 25
        },
        variationKey: {
            fontFamily: "DMSans_500Medium",
            fontSize: dpr(14),
            lineHeight: dpr(16),
            color: "#898989",
        },
        variationCont: {
            flexDirection: "row",
            justifyContent: "space-between",
            alignItems: "center",
            marginTop: dpr(12),
        },
        imageCont: {
            flexDirection: "row",
        },
        arrowStyle: {
            position: "absolute",
            right: 0,
            top: dpr(28),
        },
        scrollViewStyle: {
            position: "relative",
            flex: 1,
        },
        image: {
            marginRight: dpr(12),
            height: dpr(50),
            width: dpr(50),
            backgroundColor: "#F3F3F3",
            borderWidth: 1,
            borderColor: "#F3F3F3",
            borderRadius: 4,
        },
    });

export default VariationOptionStyle;
